<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CRedirects extends CRedirectsBackend{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "redirects";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("redirects");
			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

	

			switch ($sub) {

				case "settings":
					urlredirect("index.php?mod=modules&sub=default&action=details&module_id={$this->tpl_module[module_id]}&t=u");
				break;

				case "errors-flush":
					return $this->FlushErrors();
				break;

				case "landing":					
					$sub = "redirects";
				case "pages":					
				case "redirects":					
				case "errors":					
				case "domains":					
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);

					switch ($sub) {
						case "redirects":
							$data->functions = array( 
									"onstore" => array(&$this , "StoreRedirect"),
							);					
						break;
						case "domains":
							$data->functions = array( 
									"onstore" => array(&$this , "StoreDomain"),
									"ondelete" => array(&$this , "DeleteDomain"),
							);					
						break;
					}
					
					return $data->DoEvents();
				break;

				case "robots":
						$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);
						$this->PrepareDashboard($data->form);

						if ($data->Done()) {
							$this->vars->SetVars(
								$_POST
							);
						}
						return $data->Show($this->vars->data);
				break;


				case "action.delete":
					if (is_array($_POST["redirect_id"])) {
						$this->db->Query(
							"DELETE FROM {$this->tables['plugin:redirects']} WHERE redirect_id IN (" . implode("," , $_POST["redirect_id"]). ")"
						);
					}

					return "1";
					
				break;


				case "import":
					if (!$_GET["action"]) {
						$_GET["action"] = "edit";
					}

					
					$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);
					$this->PrepareDashboard($data->form);

					if ($data->Done()) {
						$this->ImportRedirects();
					}
					
					return $data->Show($_SESS["admin"]["action_import_newsletters"]);
				break;


				case "sitemap":
					
					$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);
					$this->PrepareDashboard($data->form);

					if ($data->Done()) {
						$this->vars->SetVars(
							$this->vars->ExtractVals(
								CForm::KeyFields($data->form),
								$_POST
							)
						);
					}
					
					return $data->Show($this->vars->data);
				break;

			}
		}
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FlushErrors() {
		//delete errors
		$this->db->Query("DELETE FROM  {$this->tables['plugin:redirects']} WHERE redirect_type=2");
		//delete stats
		$this->db->Query("DELETE FROM  {$this->tables['plugin:redirects_stats']} WHERE stat_redirect NOT IN ( select redirect_id from {$this->tables['plugin:redirects']} WHERE redirect_type=1) ");
		urlredirect($_GET["returnURL"]);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRedirect($record) {
		$this->db->Query("DELETE FROM {$this->tables['plugin:redirects']} WHERE redirect_type=2 AND redirect_source LIKE '%s'" , array($record["redirect_source"]));
	}

	
	function StoreDomain($record) {

		if ($record["domain_id"]) {

			//check for default 
			if ($record["domain_main"]) {

				$this->db->QueryUpdate(
					$this->tables["plugin:redirects_domains"],
					array( "domain_main"	=>	0) ,
					"domain_main=1 AND domain_id != {$record[domain_id]}"
				);
			}
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteDomain($record) {
		//delete all rules linked to this domain
		$this->db->Query("DELETE FROM {$this->tables['plugin:redirects']} WHERE redirect_domain=%d" , array($record["domain_id"]));
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ImportRedirects() {
		debug($_POST,1);
	}
	
}

